/************************************************************************
 *  Revision 1.0 -- converted subroutines of video board test program to
 *      a rudamentary demo program and sample code.
 *  Revision 1.1 -- the forgotten tables for 80x44 monochrome and 80x50
 *      color text modes added to the end (not best place, but people
 *      are already aware of the first 22 modes). [17 Oct 86]
 ***********************************************************************/
#include <stdio.h>
#include <dos.h>

#define FASTDOTS 0x01
#define GRAPHICS 0x02
#define B_W	 0x04
#define VIDENBL  0x08
#define G640x200 0x10
#define BLINK	 0x20

int one_bit(), one_get(), onecolor();
int two_bit(), two_get(), twocolor();
int four_bit(), four_get(), fourcolor();

unsigned int regen;
unsigned int memend;
unsigned int crtc;
unsigned int mode_reg;
unsigned int color_reg;
unsigned int row_start[512];     /* start address of each scan row */
unsigned int expand_left[256];   /* graphics text char pattern expand tables */
unsigned int expand_right[256];  /*   that expand 1 bit per pixel into 2 or 4 bpp */
unsigned int low_seg  = 0xF000;  /* graphics character generator table 0-127 addr*/
unsigned int low_ofs  = 0xFA6E;
unsigned int high_seg;	     /* graphics chars 128-255 */
unsigned int high_ofs;
unsigned int text_height = 8;    /* graphics char height */
int (*color_c)();	     /* the current write char */
unsigned int clear_word;	     /* word value to clear the buffer with */
unsigned int aspect;

/* the 6545 CRTC register numbers */
#define HTOTAL	 0
#define HDISP	 1
#define HSPOS	 2
#define HSWIDTH  3
#define VTOTAL	 4
#define VADJ	 5
#define VDISP	 6
#define VSPOS	 7
#define ILACE	 8
#define MAXSCAN  9
#define CURSTART 10
#define CUREND	 11

struct PARAMS {  /* preset data for common video modes */
   unsigned params[21];
} mode_data[] = {
   { 0xB800, 0x3FFF, 0x3D4, 0x2C, 0x30,   /* 0: 40 x 25 Text */
     0x38,0x28,0x2d,0x0a,0x1f,0x06,0x19,0x1c, 2, 7, 6, 7,0,0,0,0},

   { 0xB800, 0x3FFF, 0x3D4, 0x28, 0x30,   /* 1: 40 x 25 "B&W" Text */
     0x38,0x28,0x2d,0x0a,0x1f,0x06,0x19,0x1c, 2, 7, 6, 7,0,0,0,0},

   { 0xB800, 0x3FFF, 0x3D4, 0x2D, 0x30,   /* 2: 80 x 25 Text */
     0x71,0x50,0x5a,0x0a,0x1f,0x06,0x19,0x1c, 2, 7, 6, 7,0,0,0,0},

   { 0xB800, 0x3FFF, 0x3D4, 0x29, 0x30,   /* 3: 80 x 25 "B&W" Text */
     0x71,0x50,0x5a,0x0a,0x1f,0x06,0x19,0x1c, 2, 7, 6, 7,0,0,0,0},

   { 0xB800, 0x3FFF, 0x3D4, 0x2A, 0x30,   /* 4: 320x200 4 Color Graphics */
     0x38,0x28,0x2d,0x0a,0x7f,0x06,0x64,0x70, 2, 1, 6, 7,0,0,0,0},

   { 0xB800, 0x3FFF, 0x3D4, 0x2E, 0x30,   /* 5: 320x200 4 Color Graphics */
     0x38,0x28,0x2d,0x0a,0x7f,0x06,0x64,0x70, 2, 1, 6, 7,0,0,0,0},

   { 0xB800, 0x3FFF, 0x3D4, 0x1E, 0x3F,   /* 6: 620x200 2 Color Graphics */
     0x38,0x28,0x2d,0x0a,0x7f,0x06,0x64,0x70, 2, 1, 6, 7,0,0,0,0},

   { 0xB000, 0x0FFF, 0x3B4, 0x29, 0x30,   /* 7: 80x25 MONO Text */
     0x61,0x50,0x52,0x0f,0x19,0x06,0x19,0x19, 2,13,11,12,0,0,0,0},

   { 0xB800, 0x7FFF, 0x3D4, 0x6B, 0x30,   /* 8: 320x200 16 Color Graphics */
     0x71,0x50,0x59,0x0c,0x3f,0x06,0x32,0x38, 2, 3, 6, 7,0,0,0,0},

   { 0xB800, 0x7FFF, 0x3D4, 0x5F, 0x30,   /* 9: 640x200 4 Color Graphics */
     0x71,0x50,0x59,0x0c,0x3f,0x06,0x32,0x38, 2, 3, 6, 7,0,0,0,0},

   { 0xB000, 0xFFFF, 0x3D4, 0x6b, 0x30,   /* 10: 320x400 16 Color Graphics */
     0x71,0x50,0x59,0x0c,0x3f,0x06,0x32,0x38, 2,0x17, 6, 7,0,0,0,0},

   { 0xB000, 0xFFFF, 0x3D4, 0x5F, 0x30,   /* 11: 640x400 4 Color Graphics */
     0x71,0x50,0x59,0x0c,0x3f,0x06,0x32,0x38, 2,0x17, 6, 7,0,0,0,0},

   { 0xB000, 0x7FFF, 0x3D4, 0x1E, 0x2F,   /* 12: 640x400 2 Color Graphics */
     0x31,0x28,0x29,0x08,0x6C,0x06,0x64,0x68, 2,0x13, 6, 7,0,0,0,0},

   { 0xB000, 0x1FFF, 0x3B4, 0x29, 0x30,   /* 13: 132x25 Monochrome Text */
     0x0A5,0x84,0x89,0x0F,0x19,0x0F,0x19,0x19, 2,13,11,12,0,0,0,0},

   { 0xB000, 0x2FFF, 0x3B4, 0x29, 0x30,   /* 14: 132x44 Monochrome Text */
     0x0A5,0x84,0x89,0x0F,0x2C,0x0F,0x2C,0x2C, 2,0x27,0x86,0x87,0,0,0,0},

   { 0xB800, 0x7FFF, 0x3D4, 0x1E, 0x3F,   /* 15: 640x352 Monochrome Graphics */
     0x31,0x28,0x29,0x08,0x5c,0x06,0x58,0x58, 2, 3, 6, 7,0,0,0,0},

   { 0xB000, 0x7FFF, 0x3B4, 0x1E, 0x30,   /* 16: 720x348 Monochrome Graphics */
     0x035,0x2d,0x2e,0x07,0x5b,0x02,0x57,0x57, 2, 3, 0,0,0,0,0,0},

   { 0xB000, 0xFFFF, 0x3B4, 0x1E, 0x30,   /* 17: 1056x352 Monochrome Graphics */
     0x04E,0x42,0x42,0x08,0x2E,0x02,0x2C,0x2C,2,0x47,6,7,0,0,0,0},

   { 0xB800, 0x1FFF, 0x3D4, 0x29, 0x30,   /* 18: 132x25 Color Text */
     0x0B3,0x84,0x8E,0x0C,0x1F,0x06,0x19,0x1C,2,0x07,6,7,0,0,0,0},

   { 0xB000, 0xFFFF, 0x3D4, 0x2B, 0x30,   /* 19: 512x200 16 Color Graphics */
     0x0B3,0x80,0x8E,0x0C,0x20,0x00,0x19,0x1B,2,0x47,6,7,0,0,0,0},

   { 0xB000, 0xFFFF, 0x3D4, 0x1B, 0x30,   /* 20: 1024x200 4 Color Graphics */
     0x0B3,0x80,0x8E,0x0C,0x20,0x00,0x19,0x1B,2,0x47,6,7,0,0,0,0},

   { 0xB000, 0xFFFF, 0x3D4, 0x2B, 0x30,   /* 21: 320x352 16 Color Graphics */
     0x061,0x50,0x52,0x0F,0x2E,0x06,0x2C,0x2C,2,0x47,6,7,0,0,0,0},

   { 0xB000, 0xFFFF, 0x3D4, 0x1B, 0x30,   /* 22: 640x352 4 Color Graphics */
     0x061,0x50,0x52,0x0F,0x2E,0x06,0x2C,0x2C,2,0x47,6,7,0,0,0,0},

   { 0xB800, 0x3FFF, 0x3D4, 0x2D, 0x30,   /* 23: 80x50 Color Text */
     0x61,0x50,0x52,0x0F,0x2E,0x06,0x32,0x2C, 2,0x17,0x86,0x87,0,0,0,0},

   { 0xB000, 0x3FFF, 0x3B4, 0x29, 0x30,   /* 24: 80x44 MONO Text */
     0x61,0x50,0x52,0x0F,0x2E,0x06,0x2C,0x2C, 2,0x27,0x86,0x87,0,0,0,0}
};
#define NUMMODES (sizeof(mode_data)/sizeof(mode_data[0]))

int extmode[20]; /* list of video mode numbers to test */
struct PARAMS *setup = &extmode[0];

unsigned int xmax;
unsigned int ymax;
unsigned int zmax;
unsigned int bits_per_pixel;
unsigned int pixels_per_byte;
unsigned int textcols;
unsigned int textrows;
unsigned int max_scan;
int bios_mode;

int (*dot)();	    /* the current pixel output routine */
unsigned int (*get_dot)();   /* the current read  pixel routine */
int (*find_color)();/* the current find pixel of color routine */

int color;	    /* current drawing color */
unsigned int *color_table;   /* pointer to current color expand table */
unsigned char *get_shift;    /* pointer to read pixel shift count table */

/* tables for one bit per pixel */
unsigned char one_mask[] =   { 0x7f, 0xbf, 0xdf, 0xef, 0xf7, 0xfb, 0xfd, 0xfe };
unsigned int  one_color[] =  { /* color pattern expand table */
   0x0000, 0xFFFF, 0xFFFF, 0xFFFF,
   0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
   0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
   0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
};
char one_shift[] =  { 7, 6, 5, 4, 3, 2, 1, 0 };

/* tables for two bits per pixel */
unsigned char two_mask[] =   { 0x3F, 0xCF, 0xF3, 0xFC };
unsigned int  two_color[] =  {
   0x0000, 0x5555, 0xAAAA, 0xFFFF,
   0xFFFF, 0x5555, 0xAAAA, 0xFFFF,
   0xFFFF, 0x5555, 0xAAAA, 0xFFFF,
   0xFFFF, 0x5555, 0xAAAA, 0xFFFF
};
char two_shift[] =  { 6, 4, 2, 0 };

/* tables for four bits per pixel */
unsigned char four_mask[] =   { 0x0F, 0xF0 };
unsigned int  four_color[] =  {
   0x0000, 0x1111, 0x2222, 0x3333,
   0x4444, 0x5555, 0x6666, 0x7777,
   0x8888, 0x9999, 0xAAAA, 0xBBBB,
   0xCCCC, 0xDDDD, 0xEEEE, 0xFFFF
};
char four_shift[] =  { 4, 0 };

int hours, minutes, seconds, msecs, month, day, year, weekday;

/* Stuff for drawing test patterns */
unsigned char bar_pattern[] = {	/* blocks for drawing a color bar */
   0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0
};

char *colors[] = {
   "BLACK",  "BLUE",     "GREEN",   "CYAN",
   "RED",    "MAGENTA",  "BROWN",  "WHITE",
   "GREY",   "BLUE",     "GREEN",   "CYAN",
   "RED",    "MAGENTA",  "YELLOW",  "WHITE"
};

char *four_colors[4][4] = {  /* four color mode pallettes */
   {"BKG",  "GREEN",    "RED",       "BROWN" }, /* main pallettes */
   {"BKG",  "CYAN",     "MAGENTA",   "WHITE" },

   {"BKG",  "GREEN",    "RED",       "BROWN" }, /* alternate pallettes */
   {"BKG",  "CYAN",     "RED",       "WHITE" }
};

char *color_abbrev[] = {
   "BLK",   "BLU",   "GRN",   "CYN",
   "RED",   "MAG",   "BRN",   "WHT",
   "GRY",   "BLU",   "GRN",   "CYN",
   "RED",   "MAG",   "YEL",   "WHT"
};

main(argc, argv)
   int argc;
   char *argv[];
   {
   int i, j;
   int vmode;

   if (argc <= 1)
      goto default_mode;
   if(argc == 2) {    /* Graphics Plus II demo if "-2" only argument */
      if (strcmp(argv[1], "-2") == 0) {
         extmode[0] = 0;
         extmode[1] = 2;
         extmode[2] = 4;
         extmode[3] = 6;
         extmode[4] = 8;
         extmode[5] = 9;
         extmode[6] = 7;
         argc = 8;
         }
      else if (strcmp(argv[1], "-132") == 0) {
         extmode[0] = 7;	/* Mono 132 demo */
         extmode[1] = 13;
         extmode[2] = 14;
         argc = 4;
         }
      else if (strcmp(argv[1], "-mono") == 0 || strcmp(argv[1], "-MONO") == 0) {
default_mode:
         extmode[0] = 0;	/* HT(mono) demo */
         extmode[1] = 2;
         extmode[2] = 7;
         extmode[3] = 13;
         extmode[4] = 14;
         extmode[5] = 5;
         extmode[6] = 15;
         extmode[7] = 16;
         extmode[8] = 17;
         argc = 10;
         }
      else if (strcmp(argv[1], "-200") == 0) {
         extmode[0] = 0;
         extmode[1] = 2;
         extmode[2] = 7;
         extmode[3] = 18;
         extmode[4] = 4;
         extmode[5] = 6;
         extmode[6] = 8;
         extmode[7] = 9;
         extmode[8] = 19;
         extmode[9] = 20;
         argc = 11;
         }
      else if (strcmp(argv[1], "-350") == 0) {
         extmode[8] = 22;
         argc = 10;
         goto high_res;
         }
      else if (strcmp(argv[1], "-400") == 0) {
         argc = 11;
         extmode[8] = 10;
         extmode[9] = 11;
high_res:
         extmode[0] = 0;
         extmode[1] = 2;
         extmode[2] = 7;
         extmode[3] = 4;
         extmode[4] = 6;
         extmode[5] = 8;
         extmode[6] = 9;
         extmode[7] = 21;
         }
      else
         goto single;
      }
   else if(argc < 18) {       /* a list of pre-programmed modes */
single:
      for(i=1; i<argc; i++) { /* record parmeters in decimal */
	 extmode[i-1] = atoi(argv[i]);
         }
      }

   if(argc >= 18) {	    /* a set of CRTC params were given */
      for(i=1; i<18; i++)   /* record parmeters in hex */
	 setup->params[i-1] = atoh(argv[i]);
      setup->params[17] = 0;
      setup->params[18] = 0;
      setup->params[19] = 0;
      setup->params[20] = 0;

      bios_mode = 0;	    /* assume cant print text in this mode */
      vid_test();
      while(scr_csts() == 0);
      }
   else {   /* execute the video mode tests given on the command line */
      for(i=1; i<argc; i++) {
	 vmode = extmode[i-1];
	 if(vmode >= NUMMODES)
            continue;
	 setup = &mode_data[vmode];

	 if (vmode > 7)
	    bios_mode = vmode + 1;
	 else
	    bios_mode = 0;

	 vid_test();

	 while(scr_csts() == 0);
         }
      }
   vidmode(2);
   }

vid_test()
   {
   init();
   filler(0, regen, memend-1, clear_word); /* Blank the screen */
   if(mode_reg & GRAPHICS)
      graph_test();
   else
      text_test();
   }

atoh(s)
char s[];
{
unsigned val;

   val = 0;
   sscanf(s,"%x", &val);
   return val;
}

delay(time)    /* wait 0-10000 milliseconds */
   int time;
   {
   int i, t1, t2;
   int millis, secs;

   if((time <= 0) || (time > 10000))
      time = 1000;

   getdt();
   millis = msecs;
   secs = seconds; /* get entry time */

   while(1) {
      getdt();

      if(scr_csts())
         return (-1);

      if(seconds == 0)
         seconds = 60;
      t2 = seconds - secs;
      t2 *= 1000;

      t1 = t2 + msecs - millis;
      if(t1 < 0)
         t1 += 1000;
      if(t1 > time)
         return 0;
      }
   }

text_test()
   {
   char *t_type;
   int i;
   char s[256];

   t_type = "Color"; if(regen == 0xB000) t_type = "Monochrome";
   sprintf(s, "%dx%d %s Text", textcols, textrows, t_type);
   color_s(0, (textcols - 12)/2, 0x07, s);

   text_line(23);

   if((crtc == 0x3b4) || (xmax < 80) || (xmax > 128))
      char_set(1);
   else {
      color_bar(1);
      if (ymax > 42)
         color_bar(26);
      }

   attributes(17);

   color_s(0,0, 0x07, "CURSOR< >");
   outp(crtc, 14);
   outp(crtc+1, 0);
   outp(crtc, 15);
   outp(crtc+1, 7);
   }

graph_test()
   {
   unsigned width, height;
   unsigned x1, x2, xinc, y1, y2, yinc;
   int old_color_reg, pallette, i, j;
   char s[256];

   sprintf(s, "%d Color %dx%d Graphics", zmax, xmax, ymax);
   color_s (1, (xmax/8 - 26)/2, 0x07, s);

   set_color(1);
   box (0, 0, xmax-1, ymax-1);

   set_color(6);
   filled_box (xmax-xmax/4, ymax/2-ymax/3, xmax-xmax/16, ymax/2+ymax/3);

   for(i=0; i<ymax/4; i++) { /* h_line test */
      set_color(i);
      if(i&1)
         line(xmax/2, ymax/8+i, xmax/2+i, ymax/8+i);
      else
         line(xmax/2, ymax/8+i, xmax/2-i, ymax/8+i);
      }

   set_color(1);
   x1 = xmax/4;
   y1=ymax/2;
   j = ymax/64;
   i = (j*xmax)/ymax;
   line(x1-63*i/6, y1-14*j/4, x1+63*i/6, y1-14*j/4);
   line(x1+63*i/6, y1-14*j/4, x1-39*i/6, y1+60*j/4);
   line(x1-39*i/6, y1+60*j/4, x1, y1-60*j/4);
   line(x1, y1-60*j/4, x1+39*i/6, y1+60*j/4);
   line(x1+39*i/6, y1+60*j/4, x1-63*i/6, y1-14*j/4);
   set_color(2);
   paint(x1, y1, 1);

   i=10;
   j = 1;
   aspect = ((long)ymax)*450/xmax;
   while (aspect>8) {
      set_color(j++);
      ellipse((9*xmax)>>4, (ymax*3)>>2, xmax/7, aspect);
      i += 7;
      aspect >>= 1;
      }

   aspect = 30 * xmax / (4 * ymax);
   y1 = ymax/3;
   for (i=ymax, j=xmax/2; i > y1; i -= 10, j -= aspect)
      line(0, i, j, ymax);
   }

color_bar(line)
int line;
{
unsigned color;
unsigned row, col;
unsigned bar_height;
unsigned text_attr;

   bar_height = 16;
   for(color = 0; color < 16; color++) {
      col = color*strlen(bar_pattern);

      for(row=line; row<line+bar_height; row++) {
	 color_s(row, col, color, bar_pattern);
      }

      text_attr = color;
      if((text_attr & 0x07) == 0) text_attr = 7;
      text_attr = (text_attr << 4) & 0x7F;
      if(mode_reg & GRAPHICS) ++text_attr;
      color_s(line+bar_height/2, col+1, text_attr, color_abbrev[color]);
   }
}


attributes(line)
int line;
{
unsigned col;

   col = (textcols - 35) / 2;
   if(mode_reg & BLINK) color_s(line+1, col, 0x87,"    This line should be BLINKING    ");
   color_s(line+2, col, 0x70, "  This line should be INVERSE VIDEO ");
   color_s(line+3, col, 0x0F, "   This line should be HI-LIGHTED   ");
   if(regen == 0xB000) color_s(line+4, col, 0x01, "   This line should be UNDERLINED   ");
   color_s(line+5, col, 0x00, "   This line should NOT be VISIBLE  ");

}

text_line(line)
int line;
{
unsigned c;

   for(c=0; c<textcols; c++) {
      (*color_c)(line, c, 0x07, c+'A');
   }
}

char_set(line)
   int line;
   {
   unsigned int c, row, col, addr;
   unsigned int column;
   unsigned int attr;

   for(row=0; row<16; row++) {	/* print color names */
      attr = (row % 15) + 1;
      color_s(row + line, 0, attr, colors[attr]);
      if(xmax > 120)
	 color_s(row + line, xmax-strlen(colors[attr]), attr, colors[attr]);
      if(ymax>39) {
	 color_s(row + line + 24, 0, attr, colors[attr]);
	 if(xmax > 120)
	    color_s(row + line + 24, xmax-strlen(colors[attr]),
                  attr, colors[attr]);
	 }
      }

   for(column=0; column < (xmax-20); column+=40) {
      for(c=0; c<256; c++) {	   /* draw the char set */
	 row = c / 16;
	 attr = (row % 15) + 1;
	 col = (c % 16) * 2 + 8 + ((row^(column/40))&1);
	 (*color_c)(row + line, col+column, attr, c);
	 if (ymax>42)
	    (*color_c)(row + line + 24, (col+column) ^ 1, attr, c);
	 }
      }
   }

text_char(row, col, attr, c)
   unsigned row, col;
   unsigned char attr;
   unsigned char c;
   {
   pokew(row_start[row]+col+col, regen, (attr << 8) | c);
   }

one_char(row, col, attr, c)
   unsigned int row, col;
   unsigned int attr;
   unsigned int c;
   {
   unsigned i, seg, ofs;

   if(c & 0x80) {      /* get cgen table address !!! */
      seg = high_seg;
      ofs = high_ofs + (c & 0x7F) * text_height;
      }
   else {
      seg = low_seg;
      ofs = low_ofs + c * text_height;
      }

   row *= text_height;
   for(i=0; i<text_height; i++) {
      pokeb(row_start[row++]+col, regen, peek(ofs++, seg) & color_table[attr & 0x0F]);
      }
   }

two_char(row, col, attr, c)
   unsigned int row, col;
   unsigned int attr;
   unsigned int c;
   {
   unsigned i, seg, ofs;

   if(c & 0x80) {      /* get cgen table address !!! */
      seg = high_seg;
      ofs = high_ofs + (c & 0x7F) * text_height;
      }
   else {
      seg = low_seg;
      ofs = low_ofs + c * text_height;
      }

   col <<= 1;
   row *= text_height;
   for(i=0; i<text_height; i++) {
      pokew(row_start[row++]+col, regen, expand_left[peek(ofs++, seg) & 0xFF]
            & color_table[attr & 0x0F]);
      }
   }

four_char(row, col, attr, c)
   unsigned int row, col;
   unsigned int attr;
   unsigned int c;
   {
   unsigned int i, seg, ofs;

   if(c & 0x80) {      /* get cgen table address !!! */
      seg = high_seg;
      ofs = high_ofs + (c & 0x7F) * text_height;
      }
   else {
      seg = low_seg;
      ofs = low_ofs + c * text_height;
      }

   col <<= 2;
   row *= text_height;
   for(i=0; i<text_height; i++) {
      pokew(row_start[row]+col, regen, expand_left[c=(peek(ofs++, seg) & 0xFF)]
            & color_table[attr & 0x0F]);
      pokew(row_start[row++]+col+2, regen, expand_right[c]
            & color_table[attr & 0x0F]);
      }
   }

color_s(row, col, attr, s)
   unsigned row, col, attr;
   unsigned char s[];
   {
   int i;
   int c;

   for(i=0; (c = s[i]) != 0; i++) {
      (*color_c)(row, col+i, attr, c);
      }
   }

set_color(c)
   int c;
   {
   color = color_table[c & 0x0F];
   return color;
   }

init()
   {
   unsigned int i, j;
   unsigned int row;
   unsigned int c, mask1, mask2;

   xmax      = setup->params[5+1];
   ymax      = setup->params[5+6];
   max_scan  = setup->params[5+9] & 0x0F;

   regen     = setup->params[0];
   memend    = setup->params[1] + 1;
   crtc      = setup->params[2];
   mode_reg  = setup->params[3];
   color_reg = setup->params[4];

   zmax = 16;

   if(mode_reg & GRAPHICS) {
      high_ofs = peek(0x007C, 0x0000);	/* cgen segment table address */
      high_seg = peek(0x007E, 0x0000);

      for(i=0; i<(512/(max_scan+1)); i++) {/* for each VTOTAL */
	 row = i*(max_scan+1);		   /* base addr of group of lines */
	 for(j=0; j<=max_scan; j++)	   /* for each scan row */
	    row_start[row+j] = i * (xmax+xmax) + (j<<13); /* calc the row start address */
         }
      ymax *= (max_scan + 1);		   /* number of scan lines */

      text_height = 8;
      textrows = ymax/text_height;

      bits_per_pixel = 2;
      if(mode_reg & G640x200)
	 bits_per_pixel = 1;
      if(mode_reg & FASTDOTS)
	 bits_per_pixel *= 2;

      if(bits_per_pixel == 1) {
	 pixels_per_byte = 8;
	 textcols = xmax*2;	       /* number of text chars per row */
	 xmax *= 16;		       /* set screen rows */
	 zmax = 2;		       /* and number of colors */
	 dot = one_bit; 	       /* draw_dot function */
	 color_table = &one_color[0];  /* color lookup/expand table */
	 get_dot = one_get;	       /* read_dot function */
	 find_color = onecolor;
	 get_shift = &one_shift[0];    /* read_dot alignment shift count table */
	 color_c = one_char;	       /* text output routine */
	 clear_word = 0;	       /* buffer clearing value */
         }
      else if(bits_per_pixel == 2) {
	 pixels_per_byte = 4;
	 textcols = xmax;
	 xmax *= 8;
	 zmax = 4;
	 dot = two_bit;
	 color_table = &two_color[0];
	 get_dot = two_get;
	 find_color = twocolor;
	 get_shift = &two_shift[0];
	 color_c = two_char;
	 clear_word = 0;
	 for(c=0; c<256; c++) { /* build the text bit pattern expand table */
	    expand_left[c] = 0;
	    mask1 = 0x08;
	    for(i=0xC000; i; i>>=2) { /* color bit mask */
	       if(c & mask1)
		  expand_left[c] |= i;
	       mask1 >>= 1;
	       if(mask1 == 0)
		  mask1 = 0x80;
	       }
	    }
         }
      else {  /* 4 bits per pixel */
	 pixels_per_byte = 2;
	 textcols = xmax/2;
	 xmax *= 4;
	 zmax = 16;
	 dot = four_bit;
	 color_table = &four_color[0];
	 get_dot = four_get;
	 find_color = fourcolor;
	 get_shift = &four_shift[0];
	 color_c = four_char;
	 clear_word = 0;
	 for(c=0; c<256; c++) { /* build the text bit pattern expand table */
	    expand_left[c] = expand_right[c] = 0;
	    mask1 = 0x20;
	    mask2 = 0x02;
	    for(i=0xF000; i; i>>=4) { /* color bit mask */
	       if(c & mask1) expand_left[c] |= i;
	       mask1 >>= 1;
	       if(mask1 == 0x08) mask1 = 0x80;

	       if(c & mask2) expand_right[c] |= i;
	       mask2 >>= 1;
	       if(mask2 == 0) mask2 = 0x08;
	       }
            }
         }
      aspect = ((unsigned)ymax * 80) / xmax;
           /*  ((ymax * 5) * 64) / (xmax * 4)  */
      if(aspect > 63)
         aspect = 63;
      }
   else { /* TEXT MODE SETUPS */
      for(i=0; i<512; i++) { /* for each VTOTAL */
	 row_start[i] = i * (xmax+xmax); /* calc the row start address */
         }
      textcols = xmax;
      textrows = ymax;
      color_c = text_char;
      clear_word = 0x0720;
      }

   for(i=0; i<16; i++) {   /* program crt controller params */
      outp(crtc, i);
      outp(crtc+1, setup->params[5+i]);
      }
   pokeb(0x0465, 0, mode_reg);	/* let BIOS know what we are doing to MODE */
   outp(crtc+4, mode_reg);
   pokeb(0x0466, 0, color_reg);	/* let BIOS know what we are doing to COLOR */
   outp(crtc+5, color_reg);
   }

/*
 *
 * BOX: Draw a (color) rectangle from upper left = (x1,y1)
 *		to lower right = (x2,y2)
 *
 */
box( x1, y1, x2, y2 )
   int x1, y1, x2, y2;
   {
   line(x1,y1,x2,y1);
   line(x2,y1,x2,y2);
   line(x2,y2,x1,y2);
   line(x1,y2,x1,y1);
   }

filled_box(x1, y1, x2, y2)
   unsigned int x1,y1, x2,y2;
   {
   unsigned int t;

   if(y2<y1) {	/* draw box top to bottom */
      t=y2; y2=y1;  y1=t;
      }
   while (y1<=y2) {     /* using horizontal lines	*/
      line(x1, y1, x2, y1);
      y1++;
      }
   }

/********************************************************************
 *
 * PAINT: Fill in the convex area containing (x,y) bounded by color (bound)
 *		with color set by last call to set_color().
 *
 *******************************************************************/

paint (xi, yi, bound)
   int xi, yi, bound;
   {
   int yinc;

   yinc = -1;
   pass_paint(xi, yi, bound, yinc);
   yinc = 1;
   pass_paint(xi, yi+1, bound, yinc);
   }

pass_paint (xi, yi, bound, yinc)
   int xi, yi, bound, yinc;
   {
   int xl, xk, xn, xp, yp;

   yp = yi;
   xp = xi;
   while ((*find_color)(xp, yp, bound) == 0) {
      xp -= pixels_per_byte;
      if (xp < 0) {
         xp = 0;
         break;
         }
      }
   xl = xp + pixels_per_byte - 1;
   xp = xi;
   while ((*find_color)(xp, yp, bound) == 0) {
      xp += pixels_per_byte;
      if (xp > xmax) {
         xp = xmax;
         break;
         }
      }
   xp -= pixels_per_byte - 1;
   if (xp <= xl)
      xl = xp = xi;
   while ((*get_dot)(xl, yp) != bound)
      if (--xl < 0)
         break;
   xl++;
   while ((*get_dot)(xp, yp) != bound)
      if (++xp > xmax)
         break;
   xp--;
   if (xl > xp)
      return;

   while (1) {
      line(xl, yp, xp, yp);
      yp += yinc;
      while ((*get_dot)(xl, yp) == bound) {
         /* loss on the left */
         if (++xl > xp)
            return;
         }
      while ((*get_dot)(xl - 1, yp) != bound) {
         /* growth to left */
         if (--xl == 0)
            break;
         }
      while ((*get_dot)(xp, yp) == bound) {
         /* loss on the right */
         --xp;
         }
      while ((*get_dot)(xp + 1, yp) != bound) {
         /* growth to right */
         if (++xp == xmax)
            break;
         }
      pass_loop:
      xk = (xl + pixels_per_byte - 1)&(- pixels_per_byte);
      if (xk >= xp)
         xk = xp;
      for (xn = xl; xn < xk; xn++) {
         if ((*get_dot)(xn, yp) == bound) {
            printf("Recursive Paint Call (%d-%d, %d)\n", xl, xn-1, yp);
            pass_paint(xl, yp, bound, yinc);
            while ((*get_dot)(xn, yp) == bound)
               xn++;
            xl = xn;
            }
         }
      for (xn = xk; xn < xp; xn += pixels_per_byte) {
         if ((*find_color)(xn, yp, bound)) {
            while ((*get_dot)(xn, yp) != bound)
               xn++;
            xn--;
            if (xn < xk) {
               printf("Recursive Paint Call (%d-%d, %d)\n", xl, xn-1, yp);
               pass_paint(xl, yp, bound, yinc);
               while ((*get_dot)(xn, yp) == bound)
                  xn++;
               xl = xn;
               goto pass_loop;
               }
            break;
            }
         }
      }
   }

ellipse(x, y, major, aspect)
    int x, y, major;
    unsigned int aspect;          /* aspect ratio * 256 */
    {
    int row, col, two_x, two_y;
    long d, cincr, rincr, two_a, two_b, alpha, beta;

    d = ((long)major)*((long)aspect);
/* the following code applies if "major" is the major axis length */
#ifdef REALMAJOR
    if (aspect < 256) {
        two_a = ((long)major)*((long)major)*2;
        two_b = ((d >> 3) * (d >> 3)) >> 9;
        d = (d+64) >> 7;
        }
    else {
        two_a = ((d >> 4) * (d >> 4)) >> 7;
        two_b = ((long)major)*((long)major)*2;
        d = major * 2;
        }
#else
    two_a = ((long)major)*((long)major)*2;
    two_b = ((d >> 4) * (d >> 4)) >> 7;
    d = (d+64) >> 7;
#endif
    row = y + (d >> 1);
    col = x;
    two_x = x << 1;
    two_y = y << 1;
    alpha = two_a >> 1;
    beta = two_b >> 1;
    rincr = - (alpha * d);
    cincr = beta;
    d = ((beta - alpha) << 1) + (alpha >> 1);
/*
 *  For the remaining pare of the routine, only 'col', 'row', 'two_y',
 *  'two_x', 'color', 'two_a', 'two_b', 'cincr', 'rincr' and 'd' are
 *  use.
 */
    while (cincr + rincr < 0) {
        (*dot)(col, row);
        (*dot)(col, two_y - row);
        (*dot)(two_x - col, row);
        (*dot)(two_x - col, two_y - row);
        d += (cincr += two_b);
        col++;
        if (d >= 0) {
            d += (rincr += two_a);
            row--;
            }
        }
    while (row >= y) {
        (*dot)(col, row);
        (*dot)(col, two_y - row);
        (*dot)(two_x - col, row);
        (*dot)(two_x - col, two_y - row);
        if (d <= 0) {
            d += (cincr += two_b);
            col++;
            }
        row--;
	d += (rincr += two_a);
        }
    }

line(x1, y1, x2, y2)
   int x1, y1, x2, y2;
   {
   int i1, i2, d1, d2, d;
   unsigned addr;
   int left, right, x3, x4;

   d2 = y2 - y1;
   d1 = x2 - x1;
   if(d2 == 0) {    /* horizontal line */
      if(d1 < 0) {  /* set drawing direction */
	 left = x2;
         right = x1;
         }
      else {
	 left = x1;
         right = x2;
         }
      if(left+16 >= right) {   /* quickest way to draw short lines */
	 for(x1 = left; x1<= right; x1++)
            (*dot)(x1, y1);
	 return;
         }

      x1 = left;
      x4 = right;
      if(bits_per_pixel == 1) {
	 x2 = (left  + 7) & 0xFFF8;
	 x3 = (right - 7) & 0xFFF8;
	 left = x2 / 8;
         right = x3 / 8 - 1;
         }
      else if(bits_per_pixel == 2) {
	 x2 = (left  + 3) & 0xFFFC;
	 x3 = (right - 3) & 0xFFFC;
	 left = x2 / 4;
         right = x3 / 4 - 1;
         }
      else if(bits_per_pixel == 4) {
	 x2 = (left  + 1) & 0xFFFE;
	 x3 = (right - 1) & 0xFFFE;
	 left = x2 / 2;
         right = x3 / 2 - 1;
         }

      addr = row_start[y1];
      if(left <= right)
         filler(addr + left, regen, addr + right,
               color | (color << 8)); /* middle of line */
      if(x1 < x2)
         for( ; x1 < x2; x1++)
            (*dot)(x1, y1); /* left edge */
      if(x3 <= x4)
         for( ; x3 <= x4; x3++)
            (*dot)(x3, y1); /* right edge */
      return;
      }

   i1 = 1;
   if (d1 < 0) {
      d1 = -d1;
      i1 = -1;
      }
   i2 = 1;
   if (d2 < 0) {
      d2 = -d2;
      i2 = -1;
      }

   if(d1 > d2) {
      d = d2 + d2 - d1;
      while(1) {
	 (*dot)(x1, y1);
	 if(x1 == x2)
            break;
	 if(d >= 0) {
	    d -= (d1 + d1);
	    y1 += i2;
            }
	 d += d2 + d2;
	 x1 += i1;
         }
      }
   else {
      d = d1 + d1 - d2;
      while (1) {
	 (*dot)(x1, y1);
	 if(y1 == y2)
            break;
	 if(d >= 0) {
	    d -= (d2 + d2);
	    x1 += i1;
	 }
	 d += d1 + d1;
	 y1 += i2;
      }
   }
}

getdt()
   {  /* Read system clock - MS DOS Version */
   union REGS reg;

   reg.h.ah = 0x2A;	      /* Get DATE function */
   intdos(&reg, &reg);
   weekday = reg.h.al;
   year = reg.x.cx;
   month = reg.h.dh;
   day = reg.h.dl;

   reg.h.ah = 0x2C;	      /* Get the TIME function */
   intdos(&reg, &reg);
   hours = reg.h.ch;
   minutes = reg.h.cl;
   seconds = reg.h.dh;
   msecs = reg.h.dl * 10;
   }

scr_csts()
   {
   if (kbhit() == 0)
      return 0;
   return (0x100 | getch());
   }
